// 2003/03/18 SvFilePage.cs
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace NTF.HXD.GUI.TabPage
{
	/// <summary>
	/// t@CݒŎgpRg[
	/// </summary>
	public class SvFilePage : System.Windows.Forms.UserControl , IConfigTabPage
	{

		#region Rg[

		private System.Windows.Forms.Label label22;
		private System.Windows.Forms.Label label16;
		private System.Windows.Forms.Label label14;
		private System.Windows.Forms.Label label12;
		private System.Windows.Forms.Label label11;
		private System.Windows.Forms.Label label10;
		private System.Windows.Forms.Label label6;
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;
		private CtrlLib.NumEdit outBpsBox;
		private CtrlLib.NumEdit iUploadBox;
		private CtrlLib.NumEdit iDownloadBox;
		private CtrlLib.NumEdit tUoloadBox;
		private CtrlLib.NumEdit tDownloadBox;
		private System.Windows.Forms.CheckBox macResCheck;
		private System.Windows.Forms.Label label1;
		private CtrlLib.NumEdit upOutBpsBox;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.TextBox commentBox;
		private System.Windows.Forms.TextBox fileFolderPathBox;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Button btnFolder;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.Button btnOpen;


		#endregion



		Appli appli;

		public SvFilePage(Appli appli)
		{
			InitializeComponent();

			this.appli = appli;

			LoadConfig();
			this.Dock = DockStyle.Fill;
		}


		bool changed = false;
		public bool Changed
		{
			get{return changed;}
			set{changed = value;}
		}


		public void LoadConfig()
		{

			this.tDownloadBox.Text	= appli.ServerConfig.LimitsConfig.Total_downloads;
			this.tUoloadBox.Text		= appli.ServerConfig.LimitsConfig.Total_uploads;
			this.iDownloadBox.Text	= appli.ServerConfig.LimitsConfig.Individual_downloads;
			this.iUploadBox.Text		= appli.ServerConfig.LimitsConfig.Individual_uploads;
			this.outBpsBox.Text			= appli.ServerConfig.LimitsConfig.Out_Bps;
			this.upOutBpsBox.Text		= appli.ServerConfig.LimitsConfig.Uploader_out_Bps;
			this.commentBox.Text		= appli.ServerConfig.FilesConfig.Comment;
			this.macResCheck.Checked= appli.AppConfig.EmuMacRes;
			this.fileFolderPathBox.Text = appli.ServerConfig.PathsConfig.Files.Replace("/" , "\\");
			
			changed = false;
		}


		public void SaveConfig()
		{
			appli.ServerConfig.LimitsConfig.Total_downloads				= this.tDownloadBox.Text;
			appli.ServerConfig.LimitsConfig.Total_uploads					= this.tUoloadBox.Text;
			appli.ServerConfig.LimitsConfig.Individual_downloads	= this.iDownloadBox.Text;
			appli.ServerConfig.LimitsConfig.Individual_uploads		= this.iUploadBox.Text;
			appli.ServerConfig.LimitsConfig.Out_Bps								= this.outBpsBox.Text;
			appli.ServerConfig.LimitsConfig.Uploader_out_Bps			= this.upOutBpsBox.Text;
			appli.ServerConfig.FilesConfig.Comment								= this.commentBox.Text;
			appli.AppConfig.EmuMacRes															= this.macResCheck.Checked;
			appli.ServerConfig.PathsConfig.Files									= this.fileFolderPathBox.Text;
		}


		private void PropertyChanged(object sender, System.EventArgs e)
		{
			changed = true;
		}

		private void btnFolder_Click(object sender, System.EventArgs e)
		{
			NTF.ShellFolderBrowser folderDialog = new NTF.ShellFolderBrowser();

			NTF.BrowseFlags flags = (NTF.BrowseFlags)117;
			folderDialog.BrowseFlags = flags;
			folderDialog.Title = "t@CtH_[IĂB";
			

			if (folderDialog.ShowDialog(this))
			{
				string folderPath = folderDialog.FolderPath;
				if( folderPath.Equals("") )
				{
					return;
				}

				this.fileFolderPathBox.Text = folderPath;
			}
		}


		#region Dispose
		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion


		#region Component Designer generated code
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			this.outBpsBox = new CtrlLib.NumEdit();
			this.iUploadBox = new CtrlLib.NumEdit();
			this.iDownloadBox = new CtrlLib.NumEdit();
			this.tUoloadBox = new CtrlLib.NumEdit();
			this.tDownloadBox = new CtrlLib.NumEdit();
			this.commentBox = new System.Windows.Forms.TextBox();
			this.label22 = new System.Windows.Forms.Label();
			this.label16 = new System.Windows.Forms.Label();
			this.macResCheck = new System.Windows.Forms.CheckBox();
			this.label14 = new System.Windows.Forms.Label();
			this.label12 = new System.Windows.Forms.Label();
			this.label11 = new System.Windows.Forms.Label();
			this.label10 = new System.Windows.Forms.Label();
			this.label6 = new System.Windows.Forms.Label();
			this.label1 = new System.Windows.Forms.Label();
			this.upOutBpsBox = new CtrlLib.NumEdit();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.fileFolderPathBox = new System.Windows.Forms.TextBox();
			this.label4 = new System.Windows.Forms.Label();
			this.btnFolder = new System.Windows.Forms.Button();
			this.label5 = new System.Windows.Forms.Label();
			this.label7 = new System.Windows.Forms.Label();
			this.btnOpen = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// outBpsBox
			// 
			this.outBpsBox.InputType = CtrlLib.NumEdit.NumEditType.Integer;
			this.outBpsBox.Location = new System.Drawing.Point(205, 64);
			this.outBpsBox.Name = "outBpsBox";
			this.outBpsBox.TabIndex = 33;
			this.outBpsBox.Text = "5500";
			this.outBpsBox.TextChanged += new System.EventHandler(this.PropertyChanged);
			// 
			// iUploadBox
			// 
			this.iUploadBox.InputType = CtrlLib.NumEdit.NumEditType.Integer;
			this.iUploadBox.Location = new System.Drawing.Point(194, 237);
			this.iUploadBox.Name = "iUploadBox";
			this.iUploadBox.TabIndex = 31;
			this.iUploadBox.Text = "5500";
			this.iUploadBox.Visible = false;
			this.iUploadBox.TextChanged += new System.EventHandler(this.PropertyChanged);
			// 
			// iDownloadBox
			// 
			this.iDownloadBox.InputType = CtrlLib.NumEdit.NumEditType.Integer;
			this.iDownloadBox.Location = new System.Drawing.Point(194, 207);
			this.iDownloadBox.Name = "iDownloadBox";
			this.iDownloadBox.TabIndex = 30;
			this.iDownloadBox.Text = "5500";
			this.iDownloadBox.Visible = false;
			this.iDownloadBox.TextChanged += new System.EventHandler(this.PropertyChanged);
			// 
			// tUoloadBox
			// 
			this.tUoloadBox.InputType = CtrlLib.NumEdit.NumEditType.Integer;
			this.tUoloadBox.Location = new System.Drawing.Point(205, 38);
			this.tUoloadBox.Name = "tUoloadBox";
			this.tUoloadBox.TabIndex = 29;
			this.tUoloadBox.Text = "5500";
			this.tUoloadBox.TextChanged += new System.EventHandler(this.PropertyChanged);
			// 
			// tDownloadBox
			// 
			this.tDownloadBox.InputType = CtrlLib.NumEdit.NumEditType.Integer;
			this.tDownloadBox.Location = new System.Drawing.Point(205, 8);
			this.tDownloadBox.Name = "tDownloadBox";
			this.tDownloadBox.TabIndex = 28;
			this.tDownloadBox.Text = "5500";
			this.tDownloadBox.TextChanged += new System.EventHandler(this.PropertyChanged);
			// 
			// commentBox
			// 
			this.commentBox.Location = new System.Drawing.Point(205, 121);
			this.commentBox.MaxLength = 255;
			this.commentBox.Name = "commentBox";
			this.commentBox.Size = new System.Drawing.Size(363, 19);
			this.commentBox.TabIndex = 27;
			this.commentBox.Text = "name";
			this.commentBox.TextChanged += new System.EventHandler(this.PropertyChanged);
			// 
			// label22
			// 
			this.label22.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label22.Location = new System.Drawing.Point(19, 125);
			this.label22.Name = "label22";
			this.label22.Size = new System.Drawing.Size(147, 17);
			this.label22.TabIndex = 26;
			this.label22.Text = "ftHg̃t@C̃Rg : ";
			// 
			// label16
			// 
			this.label16.Location = new System.Drawing.Point(365, 49);
			this.label16.Name = "label16";
			this.label16.Size = new System.Drawing.Size(346, 17);
			this.label16.TabIndex = 25;
			this.label16.Text = "(Rggpł悤ɂȂ܂\[XtH_쐬܂B)";
			this.label16.Visible = false;
			// 
			// macResCheck
			// 
			this.macResCheck.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.macResCheck.Location = new System.Drawing.Point(352, 27);
			this.macResCheck.Name = "macResCheck";
			this.macResCheck.Size = new System.Drawing.Size(232, 24);
			this.macResCheck.TabIndex = 24;
			this.macResCheck.Text = "}bÑ\[Xt@Cgp\ɂB";
			this.macResCheck.Visible = false;
			this.macResCheck.CheckedChanged += new System.EventHandler(this.PropertyChanged);
			// 
			// label14
			// 
			this.label14.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label14.Location = new System.Drawing.Point(17, 68);
			this.label14.Name = "label14";
			this.label14.Size = new System.Drawing.Size(176, 17);
			this.label14.TabIndex = 23;
			this.label14.Text = "]x[down](byte/sec) : ";
			// 
			// label12
			// 
			this.label12.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label12.Location = new System.Drawing.Point(6, 211);
			this.label12.Name = "label12";
			this.label12.Size = new System.Drawing.Size(176, 17);
			this.label12.TabIndex = 21;
			this.label12.Text = "[U[ _E[h : ";
			this.label12.Visible = false;
			// 
			// label11
			// 
			this.label11.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label11.Location = new System.Drawing.Point(6, 240);
			this.label11.Name = "label11";
			this.label11.Size = new System.Drawing.Size(176, 17);
			this.label11.TabIndex = 20;
			this.label11.Text = "[U[ Abv[h : ";
			this.label11.Visible = false;
			// 
			// label10
			// 
			this.label10.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label10.Location = new System.Drawing.Point(17, 42);
			this.label10.Name = "label10";
			this.label10.Size = new System.Drawing.Size(176, 17);
			this.label10.TabIndex = 19;
			this.label10.Text = "ő Abv[h : ";
			// 
			// label6
			// 
			this.label6.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label6.Location = new System.Drawing.Point(17, 11);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(176, 17);
			this.label6.TabIndex = 18;
			this.label6.Text = "ő _E[h : ";
			// 
			// label1
			// 
			this.label1.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label1.Location = new System.Drawing.Point(16, 97);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(176, 17);
			this.label1.TabIndex = 34;
			this.label1.Text = "]x[ up ](byte/sec) : ";
			// 
			// upOutBpsBox
			// 
			this.upOutBpsBox.InputType = CtrlLib.NumEdit.NumEditType.Integer;
			this.upOutBpsBox.Location = new System.Drawing.Point(205, 93);
			this.upOutBpsBox.Name = "upOutBpsBox";
			this.upOutBpsBox.TabIndex = 35;
			this.upOutBpsBox.Text = "5500";
			this.upOutBpsBox.TextChanged += new System.EventHandler(this.PropertyChanged);
			// 
			// label2
			// 
			this.label2.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label2.Location = new System.Drawing.Point(316, 69);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(176, 17);
			this.label2.TabIndex = 36;
			this.label2.Text = "( 0 ŐȂ)";
			// 
			// label3
			// 
			this.label3.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label3.Location = new System.Drawing.Point(316, 98);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(176, 17);
			this.label3.TabIndex = 37;
			this.label3.Text = "( 0 ŐȂ)";
			// 
			// fileFolderPathBox
			// 
			this.fileFolderPathBox.Location = new System.Drawing.Point(205, 150);
			this.fileFolderPathBox.MaxLength = 255;
			this.fileFolderPathBox.Name = "fileFolderPathBox";
			this.fileFolderPathBox.Size = new System.Drawing.Size(285, 19);
			this.fileFolderPathBox.TabIndex = 38;
			this.fileFolderPathBox.Text = "name";
			this.fileFolderPathBox.TextChanged += new System.EventHandler(this.PropertyChanged);
			// 
			// label4
			// 
			this.label4.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label4.Location = new System.Drawing.Point(19, 154);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(147, 17);
			this.label4.TabIndex = 39;
			this.label4.Text = "t@CtH_ : ";
			// 
			// btnFolder
			// 
			this.btnFolder.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnFolder.Location = new System.Drawing.Point(493, 149);
			this.btnFolder.Name = "btnFolder";
			this.btnFolder.TabIndex = 40;
			this.btnFolder.Text = "I";
			this.btnFolder.Click += new System.EventHandler(this.btnFolder_Click);
			// 
			// label5
			// 
			this.label5.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label5.Location = new System.Drawing.Point(305, 213);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(270, 17);
			this.label5.TabIndex = 41;
			this.label5.Text = "( l = 2+ : 1ƖN\܂B)";
			this.label5.Visible = false;
			// 
			// label7
			// 
			this.label7.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.label7.Location = new System.Drawing.Point(305, 242);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(266, 17);
			this.label7.TabIndex = 42;
			this.label7.Text = "( l = 2+ : 1ƖN\܂B)";
			this.label7.Visible = false;
			// 
			// btnOpen
			// 
			this.btnOpen.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnOpen.Location = new System.Drawing.Point(493, 179);
			this.btnOpen.Name = "btnOpen";
			this.btnOpen.TabIndex = 43;
			this.btnOpen.Text = "tH_J";
			this.btnOpen.Click += new System.EventHandler(this.btnOpen_Click);
			// 
			// SvFilePage
			// 
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																																	this.btnOpen,
																																	this.label7,
																																	this.label5,
																																	this.btnFolder,
																																	this.label4,
																																	this.fileFolderPathBox,
																																	this.label3,
																																	this.label2,
																																	this.upOutBpsBox,
																																	this.label1,
																																	this.outBpsBox,
																																	this.iUploadBox,
																																	this.iDownloadBox,
																																	this.tUoloadBox,
																																	this.tDownloadBox,
																																	this.commentBox,
																																	this.label22,
																																	this.label16,
																																	this.macResCheck,
																																	this.label14,
																																	this.label12,
																																	this.label11,
																																	this.label10,
																																	this.label6});
			this.Name = "SvFilePage";
			this.Size = new System.Drawing.Size(584, 258);
			this.ResumeLayout(false);

		}
		#endregion

		private void btnOpen_Click(object sender, System.EventArgs e)
		{
			try
			{
				System.Diagnostics.Process.Start( this.fileFolderPathBox.Text );
			}
			catch(System.Exception error)
			{
				System.Diagnostics.Debug.WriteLine(error);
			}
		}


	}
}
